#!/usr/local/bin/perl

## SRV 7/18/97, updated 9/24/97, updated 9/26/97, altered to areamap.pl
## 6/8/98, altered to es_map 6/7/01 
## revised as make_locmap for fm1 paper 7/5/02 

`gmtset FRAME_PEN 1p BASEMAP_TYPE PLAIN DEGREE_FORMAT 2`;
#`gmtset ANOT_FONT_SIZE 8 ANOT_OFFSET 0.037`;
$gxscl=2.5; $gyscl=2.5;
`gmtset GLOBAL_X_SCALE $gxscl  GLOBAL_Y_SCALE $gyscl`;

# Entire MZ region
$prj=13;	# inches/degree
#$prj=26;
#$prj=39;
#$prj=50;
$proj="-Jm$prj";
#$lonmin=-129.1583; $lonmax=-129.0167; $latmin=47.89167; $latmax=48.04167;
#$lonmin=-129.1883; $lonmax=-128.9867; $latmin=47.89167; $latmax=48.04167;
$lonmin=-129.1667; $lonmax=-129.016; $latmin=47.89833; $latmax=48.04167; 
$bound="-R$lonmin/$lonmax/$latmin/$latmax";
$tick="-Ba3mf1m/a2mf1mEwSn";
#$xoff=2.5;  $yoff=4; 
$xoff=.5;  $yoff=.5;

$out_nm="fm1_location_map";
$out_ps="$out_nm.ps";

$all_ctd_dat="/shuksan/zephyr/hydrography/processing/scott/perl/areal";
$es_dat="/shuksan/zephyr/hydrography/processing/scott/perl/es_map_data";
$basemap="/shuksan/zephyr/topo/area12_100m+.grd";
#$basemap="/shuksan/zephyr/topo/eshydrosweep/grd_tn063_endeavour";
$cptfile="/shuksan/zephyr/hydrography/processing/scott/perl/cpts/wideverylitegrey.cpt";

##    PLOT BATHYMETRY
`psbasemap $proj $bound -K -P -V -X$xoff -Y$yoff $tick > $out_ps`;
`grdimage $basemap -C$cptfile $proj $bound -P -O -K -V >> $out_ps`;
#`grdcontour $basemap -C50 $proj $bound -W.05p -Q10 -P -O -K -V >> $out_ps`;
#`grdcontour $basemap -Cfig1cnt $proj $bound -W1p/255/255/255 -Q10 -P -O -K -V >> $out_ps`;
#`grdcontour $basemap -C10 $proj $bound -W.05p -Q10 -P -O -K -V >> $out_ps`;
#`grdcontour $basemap -C100 -A100f3 $proj $bound -W1p -Q10 -P -O -K -V >> $out_ps`;
`grdcontour $basemap -C2100 $proj $bound -W0.5p/150/150/150 -Q10 -P -O -K -V >> $out_ps`;
`grdcontour $basemap -C2200 $proj $bound -W0.5p/150/150/150 -Q10 -P -O -K -V >> $out_ps`;
`grdcontour $basemap -C2300 $proj $bound -W0.5p/150/150/150 -Q10 -P -O -K -V >> $out_ps`;
`grdcontour $basemap -C2400 $proj $bound -W0.5p/150/150/150 -Q10 -P -O -K -V >> $out_ps`;
`grdcontour $basemap -C2170 -Af3 $proj $bound -W0.5p/100/100/100 -Q10 -P -O -K -V >> $out_ps`;

$fieldboxcolor="0/0/255"; 
$difboxcolor="0/255/255";
$boxline="1p";
#$fieldboxcolor="100/100/100";  # Grey
$boxpt="1p";
#`psxy $es_dat/cirque_box.ll $proj $bound -L -W$boxline/$difboxcolor -G$difboxcolor -M -P -O -K >> $out_ps`; 
`psxy $es_dat/cirque_box.ll $proj $bound -L -W$boxline/$difboxcolor -G$difboxcolor -M -P -O -K >> $out_ps`; 
`psxy $es_dat/dune_box.ll $proj $bound -L -W$boxline/$difboxcolor -G$difboxcolor -M -P -O -K >> $out_ps`; 
`psxy $es_dat/quebec_box.ll $proj $bound -L -W$boxline/$difboxcolor -G$difboxcolor -M  -P -O -K >> $out_ps`;
`psxy $es_dat/clambed_box.ll $proj $bound -L -W$boxline/$difboxcolor -G$difboxcolor -M -P -O -K >> $out_ps`;
`psxy $es_dat/cllm $proj $bound -W$boxpt/0/0/0 -L -M -: -P -O -K >> $out_ps`;
`psxy $es_dat/cllh $proj $bound -W$boxpt/$fieldboxcolor -L -M -: -P -O -K >> $out_ps`;
`psxy $es_dat/clls $proj $bound -W$boxpt/$fieldboxcolor -L -M -: -P -O -K >> $out_ps`;
`psxy $es_dat/cllmoth $proj $bound -W$boxpt/$fieldboxcolor -L -M -: -P -O -K >> $out_ps`;
`pstext $es_dat/offaxis_fieldlets $proj $bound -P -G$fieldboxcolor -: -O -K >> $out_ps`;
`pstext $es_dat/offaxis_smdiffuselets  $proj $bound -G$difboxcolor -P -: -O -K >> $out_ps`;

$newfieldcol="0/0/200";
`psxy $es_dat/nsd2000.latlon $proj $bound -W$boxpt/$newfieldcol -L -M -: -P -O -K >> $out_ps`;
`psxy $es_dat/sd_hr2000.latlon $proj $bound -W$boxpt/$newfieldcol -L -M -: -P -O -K >> $out_ps`;
`psxy $es_dat/nmef2000.latlon $proj $bound -W$boxpt/$newfieldcol -L -M -: -P -O -K >> $out_ps`;
`psxy $es_dat/bula2.latlon $proj $bound -W$boxpt/$newfieldcol -L -M -: -P -O -K >> $out_ps`;
`pstext $es_dat/2000fieldnames  $proj $bound -G$newfieldcol -P -: -O -K >> $out_ps`;

# Plot mean current vectors?
# -SV fields: x, y, dirEofN, length... 0.03/0.12/0.1 are -SV default vals for arrow width and head size
$ascl=2;  # Divide arrow chars by this factor to make bigger/smaller
$magscl=5;
$vwidth=0.03/$gxscl/$ascl; 
$vheadw=0.12/$gxscl/$ascl; 
$vheadl=0.1/$gxscl/$ascl; 
$arrowstr="$vwidth/$vheadw/$vheadl";
# read the cm vector loc and data, rescale mags to look good, and plot with yr,dep labels
open(CMS,"<$es_dat/cm_vectors.gmtdata") || die "Can't open cm_vectors.gmtdata!\n";
open(CMTMP,">cmvects.dat") || die "Can't open cm_vects.tmp!\n";
open(CMTXT,">cmvects.txt") || die "Can't open cm_vects.tmp!\n";
$header=<CMS>;
while(<CMS>) {
  chop;
  ($yr,$dep,$lon,$lat,$dir,$mag)=split(" ",$_);
  if (($dep==2161)||($dep==2175)||($dep==2168)) {
    $newmag=$mag*$magscl;
    print CMTMP "$lon	$lat	$dir	$newmag\n";
    $cmlabelon=$lon+0.0083;
    print CMTXT "$cmlabelon $lat 4 0 7 5 $yr,$dep\n"; 
  }
}
# add a scale vector to the list
$newscalemag=0.05*$magscl;  # 0.05 m/s * scale factor for the plot
$cmlabelat=47.90416+0.0083;
print CMTMP "-129.07    47.90833 90 $newscalemag\n";
print CMTXT "-129.07    $cmlabelat 4 0 7 5 5cm/s\n";
close(CMS); close(CMTMP); close(CMTXT);
# plot the mooring locations with a +, the vectors and their labels
`psxy cmvects.dat $proj $bound -P -Sx0.05 -G0/0/0 -V -O -K >> $out_ps`;
`psxy cmvects.dat $proj $bound -P -SV$arrowstr -G0/0/0 -V -O -K >> $out_ps`;
`pstext cmvects.txt $proj $bound -G0/0/0 -P -O -K >> $out_ps`;
`rm cmvects.dat cmvects.txt`;
if (0) {
# plot vectors for near bottom currents
`psxy $es_dat/2000_wasp2161.lonlatdirmag $proj $bound -P -SV$arrowstr -G0/0/0 -V -O -K >> $out_ps`;
`psxy $es_dat/1995_cm2175.lonlatdirmag $proj $bound -P -SV$arrowstr -G0/0/0 -V -O -K >> $out_ps`;
`psxy $es_dat/fm2000_ois_cm_2168.lonlatdirmag $proj $bound -P -SV$arrowstr -G0/0/0 -V -O -K >> $out_ps`;
`psxy $es_dat/currentvectorscale.lonlatdirmag $proj $bound -P -SV$arrowstr -G0/0/0 -V -O -K >> $out_ps`;
# plot vectors for upper currents
#`psxy $es_dat/1995_cm1900.lonlatdirmag $proj $bound -P -SV$arrowstr -G255/255/255 -V -O -K >> $out_ps`;
#`psxy $es_dat/fm2000_ois_cm_2118.lonlatdirmag $proj $bound -P -SV$arrowstr -G75/75/75 -V -O -K >> $out_ps`;
#`psxy $es_dat/fm2000_ois_cm_2068.lonlatdirmag $proj $bound -P -SV$arrowstr -G125/125/125 -V -O -K >> $out_ps`;
#`psxy $es_dat/fm2000_ois_cm_2018.lonlatdirmag $proj $bound -P -SV$arrowstr -G200/200/200 -V -O -K >> $out_ps`;
#`psxy $es_dat/fm2000_ois_cm_1968.lonlatdirmag $proj $bound -P -SV$arrowstr -G255/255/255 -V -O -K >> $out_ps`;
}




##    INSET LOCATION MAP WITH LABELS
`gmtset FRAME_PEN 2p BASEMAP_TYPE PLAIN DEGREE_FORMAT 3`;
# locate upper left corner of basemap:
$fudgey=.36;	#extra num of inches to move inset lon labels off basemap...
$locxoff=-0.1;
$locyoff=$fudgey+($latmax-$latmin)*$prj;
`psbasemap -Jm0.15 -R-130/-122/46/49 -O -K -X$locxoff -Y$locyoff -P -Ba3f1/a1f1WesN >> $out_ps`;
#`psbasemap -Jm0.17 -R-130/-122/46/49 -O -K -X$locxoff -Y$locyoff -P -Ba3f1/a1f1WesN >> $out_ps`;
#`psbasemap -Jm0.27 -R-130.5/-121.75/45.5/48.5 -O -K -X$locxoff -Y$locyoff -P -Ba3f1/a1f1WesN >> $out_ps`;
#`psbasemap -Jm0.17 -R-131.5/-120/42.6/49.2 -O -K -X$locxoff -Y$locyoff -P -Ba3f1/a2f1WesN >> $out_ps`;
#`psbasemap -Jm0.18 -R-131.5/-120/42.6/49.2 -O -K -B1.5a3WesN -V >> $out_ps`;
# plot the coast line
#`pscoast -Jm -R -O -K -W -G210/180/140 -S135/206/250 -N1 -N2 >> $out_ps`;
`pscoast -Jm -R -Dh -A9 -O -K -W -G255/255/255 -S240/240/240 -N1 -N2 -V >> $out_ps`;
# overlay the plate boundary line segments
`psxy $es_dat/plate.boundaries -Jm -R -O -K -W2 -M -V >> $out_ps`;

# Small box around the ES, delineating zoom area
$lonboxmax=$lonmax+.05; $lonboxmin=$lonmin+.05;
$latboxmax=$latmax; $latboxmin=$latmin;
open(BOX, ">esbox.lonlat") || die "Can't open esbox.lonlat!\n";
print BOX "$lonboxmax	$latboxmax\n";
print BOX "$lonboxmax      $latboxmin\n";
print BOX "$lonboxmin      $latboxmin\n";
print BOX "$lonboxmin      $latboxmax\n";
print BOX "$lonboxmax      $latboxmax\n";
close(BOX);
`psxy esbox.lonlat -Jm -R -L -W.75p -G0/0/0 -O -K >> $out_ps`;

# Label pertinent features...
`pstext $es_dat/sm_es_segmentname -Jm -R -G0/0/0 -O -K >> $out_ps`;

open (WA, ">wash");
$wfont=8;
$wash="-122.9  46.65    $wfont 0 0 2 WA";
print (WA "$wash\n");
close(WA);
`pstext -Jm -R -G0/0/0 -O -K < wash >> $out_ps`;
`rm wash`;

#`pstext $es_dat/washington -Jm -R -G0/0/0 -O -K >> $out_ps`;
`pstext $es_dat/sm_nepac_name -Jm -R -G0/0/0 -O >> $out_ps`;
#`pstext $es_dat/jdf_ridgename -Jm -R -G0/0/0 -O -K >> $out_ps`;
`rm esbox.lonlat`;
#`convert $out_ps $out_nm.jpg`;

